#ifndef _STACK_H_
#define _STACK_H_

#ifdef WIN32
#include "windows.h"
#endif



#include "AudioStack/clAudioSource.h"
#include "InterfaceAudioStack.h"

#define MAX_AUDIO_SOURCES 10

namespace AudioStack
{

class clStack {
public:
  clStack();
  virtual ~clStack();
    void vResetStack();

  bool AddSource(clAudioSource &src);
  clAudioSource*  AllowSource(clAudioSource &src);
  bool RemoveSource(clAudioSource &src);
  clAudioSource *GetUnderlayingSource(clAudioSource &src) const;
  /**
   * Returns most Top source (regardless what type or group).
   * If Stack is empty NULL is returned
   */
  clAudioSource *GetTopSource() const;

  /**
   * Returns most Top source of type background.
   * If Stack doesn't contain a BG Source NULL is returned
   */
  clAudioSource *GetCurrentBgSource() const;

  /**
   * Returns ptr to most to Source of given SourceClass.
   * NULL if no source of given class is found on the stack
   */
  clAudioSource *GetTopSource(AudioSources::enAudioSources srcClass) const;

  // is implemented by the 'AudioSrcController' and switches of one source. this templte will contain 'AudioSrcController'
  bool virtual OFF(clAudioSource *source, SourceID u8SrcId);
  void trace() const;

protected:
  bool RemoveInternal_SourceClass(AudioSources::enAudioSources rmSrcClass, SourceID nextSrcID);
  bool RemoveInternal_Source(SourceID rmSrcID, SourceID nextSrcID);
  void DoPushActions(clAudioSource &src);
  void DoPopActions(clAudioSource &src);

private:
  clAudioSource *m_sources[MAX_AUDIO_SOURCES];
  int m_SP;
  clAudioSource *m_enumBgSource;

   clAudioSMEngine* getAudioSME() const;
};

// here are the members of this template. MSDEV 6.0 has a problem with cpp files defining members of template classes
// therefor the cpp must be included.
//#if defined PROJECTBUILD_VWLL_NF || defined PROJECTBUILD_NISSAN_LCN
//#include "stack.cpp"
//#endif

}//namespace

#endif // _STACK_H_
